// Define notice messages for carousel
const notices = [
  { text: 'System performance may vary during maintenance windows.', url: '#' },
  { text: 'New video encoding service is now live!', url: '#' },
  { text: 'Scheduled maintenance: Apr 30, 11PM UTC.', url: '#' }
];
// Define service placeholders (DevOps & Multimedia focus)
const services = [
  { name: 'CI/CD Pipeline',          subdomain: 'cicd',       domain: 'yourdomain.com', description: 'Automate your build, test, and deployment workflows.' },
  { name: 'Container Orchestration', subdomain: 'containers', domain: 'yourdomain.com', description: 'Manage and scale containerized applications.' },
  { name: 'Infrastructure as Code',  subdomain: 'iac',         domain: 'yourdomain.com', description: 'Define and provision infrastructure through code.' },
  { name: 'Monitoring & Logging',    subdomain: 'monitoring', domain: 'yourdomain.com', description: 'Gain real-time insights into system performance.' },
  { name: 'Video Processing',        subdomain: 'video',       domain: 'yourdomain.com', description: 'Encode, transcode, and deliver video assets.' },
  { name: 'Audio Streaming',         subdomain: 'audio',       domain: 'yourdomain.com', description: 'Stream and process audio content seamlessly.' },
  { name: 'Asset Management',        subdomain: 'assets',      domain: 'yourdomain.com', description: 'Organize and secure your digital assets.' },
  { name: 'Collaboration Hub',       subdomain: 'collab',      domain: 'yourdomain.com', description: 'Coordinate teams with integrated messaging and tasks.' },
];

// Inject service cards into the DOM
document.addEventListener('DOMContentLoaded', () => {
  // Available reveal/transition effects
  const effects = ['effect-fade', 'effect-slide', 'effect-scale', 'effect-rotate', 'effect-genie'];
  const container = document.getElementById('services-container');
  if (!container) return;
  // Setup icon mapping for services
  const iconMap = {
    'CI/CD Pipeline':          'git-merge',
    'Container Orchestration': 'cpu',
    'Infrastructure as Code':  'code',
    'Monitoring & Logging':    'bar-chart-2',
    'Video Processing':        'video',
    'Audio Streaming':         'music',
    'Asset Management':        'archive',
    'Collaboration Hub':       'users'
  };
  services.forEach(service => {
    const link = document.createElement('a');
    link.href = `https://${service.subdomain}.${service.domain}`;
    link.target = '_blank';
    link.rel = 'noopener noreferrer';
    link.className = 'service-card';

    // Create content wrapper for square card
    const contentDiv = document.createElement('div');
    contentDiv.className = 'service-content';
    // Icon wrapper
    const iconWrapper = document.createElement('div');
    iconWrapper.className = 'service-icon-wrapper';
    const iconEl = document.createElement('i');
    const iconName = iconMap[service.name] || 'box';
    iconEl.setAttribute('data-feather', iconName);
    iconEl.className = 'service-icon';
    iconWrapper.appendChild(iconEl);
    contentDiv.appendChild(iconWrapper);
    // Title
    const title = document.createElement('h3');
    title.textContent = service.name;
    contentDiv.appendChild(title);
    // Description
    const desc = document.createElement('p');
    desc.textContent = service.description;
    contentDiv.appendChild(desc);
    // Append content to card
    link.appendChild(contentDiv);
    container.appendChild(link);
  });

  // Initialize Feather icons (services and info section)
  if (window.feather) {
    feather.replace({ 'stroke-width': 2 });
  }

  // Hover-triggered random animation effects for cards
  const hoverClasses = ['hover-fade', 'hover-slide', 'hover-scale', 'hover-rotate', 'hover-genie'];
  const hoverTargets = document.querySelectorAll('.service-card, .info-card');
  hoverTargets.forEach(el => {
    el.addEventListener('mouseenter', () => {
      const cls = hoverClasses[Math.floor(Math.random() * hoverClasses.length)];
      el.classList.add(cls);
      // Remove the class after animation ends
      el.addEventListener('animationend', function handler() {
        el.classList.remove(cls);
        el.removeEventListener('animationend', handler);
      });
    });
  });

  // Randomized reveal effects for info cards
  const infoCards = document.querySelectorAll('.info-card');
  const revealObserver = new IntersectionObserver(entries => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        const card = entry.target;
        // Reveal the card with its preselected effect
        card.classList.add('active');
        revealObserver.unobserve(card);
      }
    });
  }, { threshold: 0.15 });
  infoCards.forEach(card => {
    // Assign each card a random reveal effect class
    const fx = effects[Math.floor(Math.random() * effects.length)];
    card.classList.add(fx);
    revealObserver.observe(card);
  });

  // Collapsible info cards
  document.querySelectorAll('.info-card').forEach(card => {
    const header = card.querySelector('h3');
    const para = card.querySelector('p');
    if (!header || !para) return;
    para.style.maxHeight = '0px';
    para.style.overflow = 'hidden';
    header.style.cursor = 'pointer';
    header.addEventListener('click', () => {
      const isOpen = card.classList.toggle('open');
      if (isOpen) {
        para.style.maxHeight = para.scrollHeight + 'px';
      } else {
        para.style.maxHeight = '0px';
      }
    });
  });
  // Initialize notices carousel
  const carouselWrapper = document.querySelector('.notice-wrapper');
  if (carouselWrapper) {
    notices.forEach((notice) => {
      const item = document.createElement('div');
      item.className = 'notice-item';
      const a = document.createElement('a');
      a.href = notice.url;
      a.textContent = notice.text;
      a.className = 'notice-text';
      item.appendChild(a);
      carouselWrapper.appendChild(item);
    });
    const items = carouselWrapper.querySelectorAll('.notice-item');
    let currentIdx = 0;

    function showItem(idx) {
      items.forEach((it, i) => {
        // Clear previous effect classes
        it.classList.remove(...effects);
        if (i === idx) {
          // Randomly pick a transition effect
          const fx = effects[Math.floor(Math.random() * effects.length)];
          it.classList.add(fx, 'active');
        } else {
          it.classList.remove('active');
        }
      });
    }
    function nextItem() {
      currentIdx = (currentIdx + 1) % items.length;
      showItem(currentIdx);
    }
    function prevItem() {
      currentIdx = (currentIdx - 1 + items.length) % items.length;
      showItem(currentIdx);
    }
    // Show initial notice
    showItem(currentIdx);
    let timer = setInterval(nextItem, 5000);
    document.querySelector('.notice-next').addEventListener('click', () => {
      nextItem();
      clearInterval(timer);
      timer = setInterval(nextItem, 5000);
    });
    document.querySelector('.notice-prev').addEventListener('click', () => {
      prevItem();
      clearInterval(timer);
      timer = setInterval(nextItem, 5000);
    });
  }
});